// Program to compare Short Time Autocorrelation Functions for
// Voiced and un voiced regions in speech signal
//OS: windows 7
//Scilab: 5.5.2
//

clc;
close;
clear;

[y,Fs] = wavread('C:\Users\ACER\Desktop\Number4.wav');

beg=6200; //Sample at which window is to be applied
N=600; // Length of window in samples
x=y(beg:beg+N-1); // Obtaining the required segment 
wr=window('re',N);  //Rectangular Window
Rect_seg=x.*wr;  

t=(beg:beg+N-1)/Fs;  // Adjusting the x axix to time
subplot(221)
plot(t,Rect_seg)
xlabel('Time in seconds')
title('Selected voiced segment in the signal')
c1=xcorr(Rect_seg); // Autocorrelation
lag=(1:length(c1))-ceil(length(c1)/2); // Adjusting x axix to get peak at lag=0
subplot(223)
plot(lag,c1)
title('Short Time Autocorrelation of Voiced segment')
xlabel('Lag k')
ylabel('STACF')
/////////////////////////

beg=2200; //Sample at which window is to be applied
N=600; // Length of window in samples
x=y(beg:beg+N-1); // Obtaining the required segment 
wr=window('re',N);  //Rectangular Window
Rect_seg=x.*wr;  

t=(beg:beg+N-1)/Fs;  // Adjusting the x axix to time
subplot(222)
plot(t,Rect_seg)
xlabel('Time in seconds')
title('Selected Unvoiced segment in the signal')
c1=xcorr(Rect_seg); // Autocorrelation
lag=(1:length(c1))-ceil(length(c1)/2); // Adjusting x axix to get peak at lag=0
subplot(224)
plot(lag,c1)
title('Short Time Autocorrelation of Unvoiced segment')
xlabel('Lag k')
ylabel('STACF')
